/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminStatsInQueueTableModel;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;

public abstract class VWAdminStatisticsTableModel
extends VWAdminResultTableModelBase {
    protected Date m_startTime;
    protected Date m_endTime;
    protected int m_timeUnits;

    protected abstract void buildAvailableColumnsList();

    protected abstract void retrieveRowData();

    protected abstract void retrieveStats() throws Exception;

    public VWAdminStatisticsTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
        this.m_startTime = event.getStartTime();
        this.m_endTime = event.getEndTime();
        this.m_timeUnits = event.getTimeUnits();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getCellElement(rowIndex, columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setCellElement(aValue, rowIndex, columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int index) {
        return String.class;
    }

    public void getNextBatch() throws Exception {
        this.retrieveStats();
        this.buildAvailableColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void refreshTable() {
        try {
            this.retrieveColumnNames();
            this.retrieveRowData();
            this.fireTableChanged(new TableModelEvent(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    protected void initTable() throws Exception {
        this.getFirstBatch();
    }

    protected int fetchQueryCount() throws Exception {
        return -1;
    }

    protected void getFirstBatch() throws Exception {
        this.retrieveStats();
        this.buildAvailableColumnsList();
        this.buildSelectedColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Object getObjectAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            return rowData.elementAt(columnIndex);
        }
        return null;
    }

    protected Object getCellElement(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            return rowData.elementAt(columnIndex);
        }
        return null;
    }

    protected void setCellElement(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
    }

    protected void retrieveColumnNames() {
        try {
            String headerName;
            int i;
            if (this.m_headers != null) {
                this.m_headers.removeAllElements();
            }
            if (this.m_objectCache.size() <= 0) {
                return;
            }
            String statName = null;
            statName = this instanceof VWAdminStatsInQueueTableModel ? VWResource.s_queueName : VWResource.s_rosterName;
            for (i = 0; i < this.m_selectedColumns.size() && VWStringUtils.compareIgnoreCase(headerName = (String)this.m_selectedColumns.elementAt(i), statName) != 0; ++i) {
            }
            if (i >= this.m_selectedColumns.size()) {
                this.m_headers.addElement(statName);
            }
            for (i = 0; i < this.m_selectedColumns.size(); ++i) {
                this.m_headers.addElement((String)this.m_selectedColumns.elementAt(i));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void buildSelectedColumnsList() {
        try {
            this.m_selectedColumns.removeAllElements();
            if (this.m_selectedColumnsFromQuery != null) {
                for (int i = 0; i < this.m_selectedColumnsFromQuery.length; ++i) {
                    if (!this.isInVector(this.m_selectedColumnsFromQuery[i], this.m_availableColumns)) continue;
                    this.m_selectedColumns.addElement(this.m_selectedColumnsFromQuery[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean validateDate(Object value) {
        boolean isOK = true;
        if (value instanceof Date) {
            isOK = value == null ? true : VWAdminFieldsTableData.NO_DATE.longValue() != ((Date)value).getTime() && VWAdminFieldsTableData.NO_TIMER.longValue() != ((Date)value).getTime() && VWAdminFieldsTableData.NO_TIME.longValue() != ((Date)value).getTime();
        }
        return isOK;
    }
}

